IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_BancoBBVA_Proveedores_OP_Reg_25_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_BancoBBVA_Proveedores_OP_Reg_25_TX
END
GO

CREATE FUNCTION [dbo].[CF_BancoBBVA_Proveedores_OP_Reg_25_TX](@pId_Trans INT, @pId_Valor INT, @pCuitEmpresa VARCHAR(13), @pNroSecuencia INT) 
RETURNS CHAR(850)
AS
BEGIN

/*================================================================================================================================*/

/*Variables del Archivo*/
DECLARE @Retorno						CHAR(850)

/*--------------------------------------------------------------------------------------------------------------------------------*/

DECLARE @aIDENT_REGISTRO	CHAR(4)		-- NRO: 01. NOMBRE: IDENT-REGISTRO. TIPO: N. TAM: 004. POS. INI: 1. POS_FIN: 4. OBSERVACION:OBL fijo 0306
DECLARE @aTIPO_REG			CHAR(3)		-- NRO: 02. NOMBRE: TIPO-REG.		TIPO: N. TAM: 003. POS. INI: 5. POS_FIN: 7. OBSERVACION:OBL fijo 025
DECLARE @aTIPO_DOC_EMPRE	CHAR(4)		-- NRO: 03. NOMBRE: TIPO-DOC-EMPRE. TIPO: X. TAM: 004. POS. INI: 8. POS_FIN: 11. OBSERVACION:OBL 'CUIT' tipo documento
DECLARE @aNRO_CUIT_EMPRE	CHAR(13)	-- NRO: 04. NOMBRE: NRO-CUIT-EMPRE. TIPO: N. TAM: 013. POS. INI: 12. POS_FIN: 24. OBSERVACION:OBL nmero de CUIT
DECLARE @aSECUENCIA			CHAR(6)		-- NRO: 05. NOMBRE: SECUENCIA.		TIPO: N. TAM: 006. POS. INI: 25. POS_FIN: 30. OBSERVACION:OBL Nmero correlativo
DECLARE @aFILLER_A			CHAR(15)	-- NRO: 06. NOMBRE: FILLER.			TIPO: X. TAM: 015. POS. INI: 31. POS_FIN: 45. OBSERVACION:Relleno a  blancos
DECLARE @aNRO_MINUTA		CHAR(8)		-- NRO: 07. NOMBRE: NRO-MINUTA.		TIPO: N. TAM: 008. POS. INI: 46. POS_FIN: 53. OBSERVACION:OBL nmero de orden de pago. Debe ser mayor a ceros.  Se repetir el mismo valor que el registro 20.
DECLARE @aIMPORTE			CHAR(13)	-- NRO: 08. NOMBRE: IMPORTE.		TIPO: N. TAM: 013. POS. INI: 54. POS_FIN: 66. OBSERVACION:OBL Numrico con dos decimales. Importe del medio de pago.   
DECLARE @aFILLER_B			CHAR(125)	-- NRO: 09. NOMBRE: FILLER.			TIPO: X. TAM: 125. POS. INI: 67. POS_FIN: 191. OBSERVACION:Relleno a  blancos
DECLARE @aIPERMFIN			CHAR(1)		-- NRO: 10. NOMBRE: IPERMFIN.		TIPO: X. TAM: 001. POS. INI: 192. POS_FIN: 192. OBSERVACION:OPC Para forma de pago CH indica  financiacin automtica. S: permite,  Blanco o N: no se utiliza
DECLARE @aFILLER_C			CHAR(58)	-- NRO: 11. NOMBRE: FILLER.			TIPO: X. TAM: 058. POS. INI: 193. POS_FIN: 250. OBSERVACION:Relleno a  blancos
DECLARE @aPRO_CBU_NRO		CHAR(22)	-- NRO: 12. NOMBRE: PRO-CBU-NRO.	TIPO: N. TAM: 022. POS. INI: 251. POS_FIN: 272. OBSERVACION:OPC Nmero CBU.  Obligatorio para forma de pago AB acreditacin en cuenta, si se informa en este tipo de registro, no es necesario informarlo en el registro 90.
DECLARE @aFECHA_PAGO		CHAR(8)		-- NRO: 13. NOMBRE: FECHA-PAGO.		TIPO: N. TAM: 008. POS. INI: 273. POS_FIN: 280. OBSERVACION:OBL Fecha de pago. Si es CPD debe ser mayor a la fecha de entrega formato aaaammdd. Si es crdito en cuenta debe ser hbil y mayor o igual a la fecha de entrega. Si es cheque al da debe ser igual a la de entrega.
DECLARE @aFORMA_PAGO		CHAR(2)		-- NRO: 14. NOMBRE: FORMA-PAGO.		TIPO: X. TAM: 002. POS. INI: 281. POS_FIN: 282. OBSERVACION:OBL Forma de pago. AB para Acreditacin en cuenta. CH para Emisin de Cheques. ACLARACIN: Si se quiere informar para la misma orden de pago distintas formas de pago, la forma de pago en el REG-10 debe tener el valor 99, de lo contrario la forma de pago definida en el REG-10 ser mandatoria en los REG-25.
DECLARE @aFILLER_D			CHAR(1)		-- NRO: 15. NOMBRE: FILLER.			TIPO: X. TAM: 001. POS. INI: 283. POS_FIN: 283. OBSERVACION:Relleno a  blancos
DECLARE @aDISPON_P			CHAR(1)		-- NRO: 16. NOMBRE: DISPON-P.		TIPO: N. TAM: 001. POS. INI: 284. POS_FIN: 284. OBSERVACION:OPC. En caso de informar Forma de Pago CH, indicar 0 para CPD cruzado no a la orden; 1 CPD cruzado a la orden; 2 CPD no cruzado a la orden; 3 CPD no cruzado no a la orden; 4 Cheque al da cruzado no a la orden; 5 Cheque al da cruzado a la orden; 6 Cheque al da no cruzado a la orden; 7 Cheque al da no cruzado no a la orden. En caso de informar Forma de Pago AB, indicar 0 para Contrato (ve contrato); 1 para COELSA; 2 para CCI (si l CBU relacionado con el pago es de un banco que no forma parte de INTERBANKING, para no rechazar la transferencia, se cambia por 1 y la misma se har por COELSA). En caso contrario debe ir completo con ceros. ACLARACIN: Se tomara el valor de este campo si en el registro se complet con el valor 9 en el reg-20. De lo contrario se tomara el valor informado en dicho registro  para todos los registros 25.cruzado a la orden; 7 Cheque al da no cruzado no a la orden. En caso de informar Forma de Pago AB, indicar 0 para Contrato (ve contrato); 1 para COELSA; 2 para CCI (si l CBU relacionado con el pago es de un banco que no forma parte de INTERBANKING, para no rechazar la transferencia, se cambia por 1 y la misma se har por COELSA).
DECLARE @aFILLER_E			CHAR(1)		-- NRO: 17. NOMBRE: FILLER.			TIPO: N. TAM: 001. POS. INI: 285. POS_FIN: 285. OBSERVACION:Relleno a  blancos
DECLARE @aNRO_CHEQUE		CHAR(13)	-- NRO: 18. NOMBRE: NRO-CHEQUE.		TIPO: X. TAM: 013. POS. INI: 286. POS_FIN: 298. OBSERVACION:OPC Nmero de cheque emitido. Obligatorio si el parmetro Informa Nmero de Cheque del contrato tienen la marca en S. Informar comenzando con 8 alineado a la izquierda, y justificar con ceros a la derecha.
DECLARE @aCOD_DEVOLUCION	CHAR(6)		-- NRO: 19. NOMBRE: COD-DEVOLUCION. TIPO: X. TAM: 006. POS. INI: 299. POS_FIN: 304. OBSERVACION:OPC Relleno a blancos.  En la devolucin se enva el nmero de cdigo de devolucin.
DECLARE @aDESC_DEVOLUCION	CHAR(40)	-- NRO: 20. NOMBRE: DESC-DEVOLUCION.TIPO: A. TAM: 040. POS. INI: 305. POS_FIN: 344. OBSERVACION:OPC. Descripciones relacionadas al Cdigo de Devolucin.
DECLARE @aFILLER_F			CHAR(506)	-- NRO: 21. NOMBRE: FILLER.			TIPO: X. TAM: 506. POS. INI: 345. POS_FIN: 850. OBSERVACION:Relleno a  blancos
/*FIN Variables del Archivo*/

/*================================================================================================================================*/

/*Variables de Calculo intermedio*/
DECLARE @Importe					DECIMAL(12,2)
DECLARE @Fecha_Cbte					DATETIME
DECLARE @Id_Tipo_Val				CHAR(3)
DECLARE @Fecha_Emision				DATETIME
DECLARE @Fecha_Acreditacion			DATETIME
DECLARE @Transferible				TINYINT
/*FIN Variables de Calculo intermedio*/


/*Asignacion de variables*/
SELECT
@Importe			= ISNULL(Importe, 0),
@Id_Tipo_Val		= ISNULL(Id_Tipo_Val, '   '),
@Fecha_Emision		= CONVERT(DATE, ISNULL(Fecha_Emision, '19000101')),
@Fecha_Acreditacion	= CONVERT(DATE, ISNULL(Fecha_Acreditacion, '19000101')),
@Transferible		= ISNULL(Transferible, 0)
FROM Valores
WHERE
Id_Trans = @pId_Trans
AND Id_Valor = @pId_Valor

SELECT
@Fecha_Cbte		= ISNULL(Fecha, '19000101')
FROM Cbtes
WHERE
Id_Trans = @pId_Trans
/*FIN Asignacion de variables*/

/*================================================================================================================================*/

SET @aIDENT_REGISTRO	= '0306'
SET @aTIPO_REG			= '025'
SET @aTIPO_DOC_EMPRE	= 'CUIT'
SET @aNRO_CUIT_EMPRE	= (SELECT RIGHT('0000000000000' + CAST(@pCuitEmpresa AS VARCHAR), 13))
SET @aSECUENCIA			= (SELECT RIGHT('000000' + CAST(@pNroSecuencia AS VARCHAR), 6))
SET @aFILLER_A			= '               '
SET @aNRO_MINUTA		= (SELECT RIGHT('00000000' + CAST(@pId_Trans AS VARCHAR), 8))
SET @aIMPORTE			= (SELECT RIGHT( '0000000000000' + CAST(CAST((ISNULL(@Importe,0)) * 100 AS INT) AS VARCHAR), 13))
SET @aFILLER_B			= '                                                                                                                             '
SET @aIPERMFIN			= ' '
SET @aFILLER_C			= '                                                          '
SET @aPRO_CBU_NRO		= '                      '
SET @aFECHA_PAGO		= (/*AAAA*/CAST(DATEPART(YY, @Fecha_Cbte) AS CHAR(4)) + /*MM*/RIGHT('00' + CAST(DATEPART(mm, @Fecha_Cbte) AS VARCHAR),2) + /*DD*/RIGHT('00' + CAST(DATEPART(dd, @Fecha_Cbte) AS VARCHAR),2))
IF(@Id_Tipo_Val IN ('CH3', 'CHP'))
BEGIN
	SET @aFORMA_PAGO		= 'CH'
END
ELSE
BEGIN
	SET @aFORMA_PAGO		= 'AB' /*Acreditacion en Cuenta*/
END	
SET @aFILLER_D			= ' '

/*OPC  En caso de informar 
Forma de Pago 

CH, indicar 0 para CPD cruzado no a la orden; 
			1 CPD cruzado a la orden; 
			2 CPD no cruzado a la orden; 
			3 CPD no cruzado no a la orden; 
			4 Cheque al da cruzado no a la orden; 
			5 Cheque al da cruzado a la orden; 
			6 Cheque al da no cruzado a la orden; 
			7 Cheque al da no cruzado no a la orden. 
			
AB, indicar 0 para Contrato (ve contrato); 
			1 para COELSA; 
			2 para CCI (si l CBU relacionado con el pago es de un banco que no forma parte de INTERBANKING, para no rechazar la transferencia, se cambia por 1 y la misma se har por COELSA).
En caso contrario debe ir completo con ceros.
ACLARACIN: integrar slo si no se complet en la cabecera.*/
IF(@Fecha_Emision = @Fecha_Acreditacion)
BEGIN
	/*Cheque al dia*/
	IF(@Transferible = 1)
	BEGIN
		/*No a la orden*/
		SET @aDISPON_P		= 4
	END
	ELSE
	BEGIN
		/*A la Orden*/
		SET @aDISPON_P		= 5
	END
END
ELSE
BEGIN
	/*Cheque Pago Diferido (CPD)*/
	IF(@Transferible = 1)
	BEGIN
		/*No a la orden*/
		SET @aDISPON_P		= 0
	END
	ELSE
	BEGIN
		/*A la Orden*/
		SET @aDISPON_P		= 1
	END
END	

SET @aFILLER_E			= ' '
SET @aNRO_CHEQUE		= '0000000000000'
SET @aCOD_DEVOLUCION	= '      '
SET @aDESC_DEVOLUCION	= '                                        '
SET @aFILLER_F			= '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          '

/*================================================================================================================================*/

SET @Retorno =	@aIDENT_REGISTRO	+ 
				@aTIPO_REG			+ 
				@aTIPO_DOC_EMPRE	+ 
				@aNRO_CUIT_EMPRE	+ 
				@aSECUENCIA			+ 
				@aFILLER_A			+ 
				@aNRO_MINUTA		+ 
				@aIMPORTE			+ 
				@aFILLER_B			+ 
				@aIPERMFIN			+ 
				@aFILLER_C			+ 
				@aPRO_CBU_NRO		+ 
				@aFECHA_PAGO		+ 
				@aFORMA_PAGO		+ 
				@aFILLER_D			+ 
				@aDISPON_P			+ 
				@aFILLER_E			+ 
				@aNRO_CHEQUE		+ 
				@aCOD_DEVOLUCION	+ 
				@aDESC_DEVOLUCION	+ 
				@aFILLER_F

/*================================================================================================================================*/
					
RETURN @Retorno
END